import requests
import os
import discord
from pystyle import Colors, Colorate, Center
import time
import base64
import random

os.system("title Emoji Cloner - PyZen Service")

SAVE_DIR = "downloaded_emojis"

if not os.path.exists(SAVE_DIR):
    os.makedirs(SAVE_DIR)

def clear():
    os.system("cls" if os.name == "nt" else "clear")

def banner():
    print(Colorate.Horizontal(Colors.red_to_blue, Center.XCenter(r"""
__________                _____________    ______________                         
___  ____/______ _______________(_)__(_)   __  ____/__  /_________________________
__  __/  __  __ `__ \  __ \____  /__  /    _  /    __  /_  __ \_  __ \  _ \_  ___/
_  /___  _  / / / / / /_/ /___  / _  /     / /___  _  / / /_/ /  / / /  __/  /    
/_____/  /_/ /_/ /_/\____/___  /  /_/      \____/  /_/  \____//_/ /_/\___//_/     
                          /___/                                                   
                                                                   
""")))

def option_banner():
    print(Colorate.Horizontal(Colors.red_to_blue, Center.XCenter(r"""
╔══════════════════════════════════════════════════════════╗
║ 1. Download Emojis (User Token)                          ║
║ 2. Download Emojis (Bot Token)                           ║
║ 3. Upload Emojis (User Token)                            ║
║ 4. Upload Emojis (Bot Token)                             ║
║ 5. Exit                                                  ║
╚══════════════════════════════════════════════════════════╝
""")))

def intro():
    for i in range(5):
        clear()
        time.sleep(0.1)
        print(Colorate.Vertical(Colors.red_to_blue, Center.Center(r"""
________        ______                  ________                  _____            
___  __ \____  ____  /____________      __  ___/______________   ____(_)__________ 
__  /_/ /_  / / /_  / _  _ \_  __ \     _____ \_  _ \_  ___/_ | / /_  /_  ___/  _ \
_  ____/_  /_/ /_  /__/  __/  / / /     ____/ //  __/  /   __ |/ /_  / / /__ /  __/
/_/     _\__, / /____/\___//_/ /_/      /____/ \___//_/    _____/ /_/  \___/ \___/ 
        /____/

                                                                  

                                                                  
                                                                  """)))
        time.sleep(0.1)

# Download Emojis via User
def download_emojis_user():
    U_TOKEN = input(Colorate.Horizontal(Colors.red_to_blue, "User Token: ")).strip()
    GUILD_ID = input(Colorate.Horizontal(Colors.red_to_blue, "Guild ID: ")).strip()
    HEADERS = {
        "Authorization": U_TOKEN,
        "User-Agent": "Mozilla/5.0"
    }

    url = f"https://discord.com/api/v10/guilds/{GUILD_ID}/emojis"
    r = requests.get(url, headers=HEADERS)
    
    if r.status_code != 200:
        print(Colorate.Horizontal(Colors.red_to_white, f"Failed to fetch emojis: {r.status_code}"))
        print(Colorate.Horizontal(Colors.red_to_blue, r.text))
        return

    emojis = r.json()
    print(Colorate.Horizontal(Colors.green_to_white, f"Found {len(emojis)} emojis."))

    for emoji in emojis:
        emoji_id = emoji["id"]
        emoji_name = emoji["name"]
        animated = emoji["animated"]
        file_ext = "gif" if animated else "png"
        url = f"https://cdn.discordapp.com/emojis/{emoji_id}.{file_ext}"

        file_path = os.path.join(SAVE_DIR, f"{emoji_name}_{emoji_id}.{file_ext}")
        emoji_data = requests.get(url).content

        with open(file_path, "wb") as f:
            f.write(emoji_data)
            print(Colorate.Horizontal(Colors.green_to_white, f"Saved {emoji_name}.{file_ext}"))

# Download Emojis via Bot
def download_emojis_bot():
    BOT_TOKEN = input(Colorate.Horizontal(Colors.red_to_blue, "Bot Token: ")).strip()
    GUILD_ID = int(input(Colorate.Horizontal(Colors.red_to_blue, "Guild ID: ")).strip())

    class EmojiDownloader(discord.Client):
        async def on_ready(self):
            print(f"Logged in as {self.user}")
            guild = self.get_guild(GUILD_ID)
            if not guild:
                print(Colorate.Horizontal(Colors.red_to_white, "Guild not found."))
                await self.close()
                return
            emojis = guild.emojis
            print(Colorate.Horizontal(Colors.green_to_white, f"Found {len(emojis)} emojis."))
            for emoji in emojis:
                url = str(emoji.url)
                ext = "gif" if emoji.animated else "png"
                file_path = os.path.join(SAVE_DIR, f"{emoji.name}_{emoji.id}.{ext}")
                async with self.http._HTTPClient__session.get(url) as resp:
                    if resp.status == 200:
                        with open(file_path, "wb") as f:
                            f.write(await resp.read())
                        print(Colorate.Horizontal(Colors.green_to_white, f"Saved {emoji.name}.{ext}"))
            await self.close()

    intents = discord.Intents.default()
    client = EmojiDownloader(intents=intents)
    client.run(BOT_TOKEN)

# Upload Emojis via Bot
def upload_emojis_bot():
    BOT_TOKEN = input(Colorate.Horizontal(Colors.red_to_blue, "Bot Token: ")).strip()
    GUILD_ID = int(input(Colorate.Horizontal(Colors.red_to_blue, "Guild ID: ")).strip())

    class EmojiUploader(discord.Client):
        async def on_ready(self):
            print(f"Logged in as {self.user}")
            guild = self.get_guild(GUILD_ID)
            if not guild:
                print(Colorate.Horizontal(Colors.red_to_white, "Guild not found."))
                await self.close()
                return
            files = [f for f in os.listdir(SAVE_DIR) if f.endswith((".png", ".gif"))]
            for idx, filename in enumerate(files, 1):
                emoji_name = f"PyZen_{idx}"
                with open(os.path.join(SAVE_DIR, filename), "rb") as f:
                    image = f.read()
                try:
                    await guild.create_custom_emoji(name=emoji_name, image=image)
                    print(Colorate.Horizontal(Colors.green_to_white, f"Uploaded {filename} as {emoji_name}"))
                except Exception as e:
                    print(Colorate.Horizontal(Colors.red_to_white, f"Failed to upload {filename}: {e}"))
            await self.close()

    intents = discord.Intents.default()
    client = EmojiUploader(intents=intents)
    client.run(BOT_TOKEN)

# Upload Emojis via User
def upload_emojis_user():

    U_TOKEN = input(Colorate.Horizontal(Colors.red_to_blue, "User Token: ")).strip()
    GUILD_ID = input(Colorate.Horizontal(Colors.red_to_blue, "Guild ID: ")).strip()

    HEADERS = {
        "Authorization": U_TOKEN,
        "Content-Type": "application/json",
        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 "
                      "(KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36",
        "X-Requested-With": "XMLHttpRequest",
        "Referer": "https://discord.com/channels/@me",
        "Origin": "https://discord.com"
    }

    # Get existing emojis first
    r = requests.get(f"https://discord.com/api/v10/guilds/{GUILD_ID}/emojis", headers=HEADERS)
    if r.status_code != 200:
        print(Colorate.Horizontal(Colors.red_to_white, f"Failed to get existing emojis: {r.status_code}"))
        return

    existing_emojis = [e["name"] for e in r.json()]
    print(Colorate.Horizontal(Colors.green_to_white, f"Found {len(existing_emojis)} existing emojis."))

    # Prepare and shuffle file list
    files = [f for f in os.listdir(SAVE_DIR) if f.endswith((".png", ".gif"))]
    random.shuffle(files)

    for idx, filename in enumerate(files, 1):

        emoji_name = f"PyZen_{idx}"

        if emoji_name in existing_emojis:
            print(Colorate.Horizontal(Colors.red_to_white, f"Skipped {filename} (already exists)"))
            continue

        ext = filename.split(".")[-1]
        with open(os.path.join(SAVE_DIR, filename), "rb") as f:
            b64_image = base64.b64encode(f.read()).decode()

        payload = {
            "name": emoji_name,
            "image": f"data:image/{ext};base64,{b64_image}"
        }

        url = f"https://discord.com/api/v10/guilds/{GUILD_ID}/emojis"
        r = requests.post(url, headers=HEADERS, json=payload)

        if r.status_code == 201:
            print(Colorate.Horizontal(Colors.green_to_white, f"Uploaded {filename}"))
        else:
            print(Colorate.Horizontal(Colors.red_to_white, f"Failed to upload {filename}: {r.text}"))

        # Add delay to mimic human behavior
        time.sleep(random.uniform(3.5, 6.5))

def main():
    intro()
    clear()
    banner()
    option_banner()

    while True:
        choice = input(Colorate.Horizontal(Colors.red_to_blue, ">>> ")).strip()
        if choice == "1":
            download_emojis_user()
        elif choice == "2":
            download_emojis_bot()
        elif choice == "3":
            upload_emojis_user()
        elif choice == "4":
            upload_emojis_bot()
        elif choice == "5":
            print(Colorate.Horizontal(Colors.red_to_white, "Exiting..."))
            break
        else:
            print(Colorate.Horizontal(Colors.red_to_white, "Invalid option. Please try again."))
        clear()
        banner()
        option_banner()



if __name__ == "__main__":
    main()
